<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:param name="sref"></xsl:param>
<xsl:param name="sblk"></xsl:param>
<xsl:param name="lang">en</xsl:param>
<xsl:template match="/">
<html>
<body>
	<table id='tblvolt' width='100%' border='1'>
		<tr>
			<th colspan='12' align="left">
				<xsl:if test="$lang != 'ja'">VOLTAGE TABLE</xsl:if><xsl:if test="$lang = 'ja'">電圧値表</xsl:if>
			</th>
		</tr>
		<tr>
			<th><xsl:if test="$lang != 'ja'">BLOCK</xsl:if><xsl:if test="$lang = 'ja'">ブロック</xsl:if></th>
			<th><xsl:if test="$lang != 'ja'">REF</xsl:if><xsl:if test="$lang = 'ja'">シンボル</xsl:if></th>
			<th><xsl:if test="$lang != 'ja'">PIN</xsl:if><xsl:if test="$lang = 'ja'">端子</xsl:if></th>
			<xsl:for-each select="//ROW[@NO='1']/V">
				<th>
					<xsl:value-of select="@MODE"/>
				</th>
			</xsl:for-each>
		</tr>
		<xsl:if test="$sref != '' and $sblk = ''">
			<xsl:choose>
				<xsl:when test="$sref = '*'">
					<xsl:apply-templates select="//ROW" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="//ROW[@REF=$sref]" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$sref != '' and $sblk != ''">
			<xsl:apply-templates select="//ROW[@REF=$sref and @BLK=$sblk]" />
		</xsl:if>
		<xsl:if test="$sref = '' and $sblk != ''">
			<xsl:apply-templates select="//ROW[@BLK=$sblk]" />
		</xsl:if>
		<xsl:if test="$sref = '' and $sblk = ''">
			<xsl:apply-templates select="//ROW[contains(@REF,' ')]" />
		</xsl:if>
	</table>
</body>
</html>
</xsl:template>

<xsl:template match="//ROW">
	<tr style="background:white">
		<xsl:attribute name="class">
			<xsl:value-of select="@BLK"/><xsl:value-of select="@REF"/>
		</xsl:attribute>
		<td nowrap="nowrap">
			<xsl:if test="@BLK[. != '']"><xsl:value-of select="@BLK"/></xsl:if>
			<xsl:if test="@BLK[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="count(V/@WL[. != '']) != 0">
				<a id='ref' onmouseover="this.style.cursor='pointer';this.style.color='red';" onmouseout="this.style.color='royalblue';">
					<xsl:attribute name="onclick">
						showWaveform('<xsl:value-of select="@REF"/>','','<xsl:value-of select="@BLK"/>','')
					</xsl:attribute>
					<xsl:if test="@REF[. != '']"><xsl:value-of select="@REF"/></xsl:if>
					<xsl:if test="@REF[. = '']"><br/></xsl:if>
				</a>
			</xsl:if>
			<xsl:if test="count(V/@WL[. != '']) = 0">
					<xsl:if test="@REF[. != '']"><xsl:value-of select="@REF"/></xsl:if>
					<xsl:if test="@REF[. = '']"><br/></xsl:if>
			</xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="@PIN[. != '']"><xsl:value-of select="@PIN"/></xsl:if>
			<xsl:if test="@PIN[. = '']"><br/></xsl:if>
		</td>
		<xsl:for-each select="V">
			<td nowrap="nowrap">
				<xsl:attribute name="title"><xsl:value-of select="@MODE"/></xsl:attribute>
				<xsl:if test="@WL != ''">
					<a id='ref' onmouseover="this.style.cursor='pointer';this.style.color='red';" onmouseout="this.style.color='royalblue';">
						<xsl:attribute name="onclick">
							showWaveform('<xsl:value-of select="../@REF"/>','<xsl:value-of select="../@PIN"/>','<xsl:value-of select="../@BLK"/>','<xsl:value-of select="@MODE"/>')
						</xsl:attribute>
						<xsl:if test=". != ''"><xsl:value-of select="."/></xsl:if>
						<xsl:if test=". = ''">+++</xsl:if>
					</a>
				</xsl:if>
				<xsl:if test="@WL = ''">
					<xsl:if test=". != ''"><xsl:value-of select="."/></xsl:if>
					<xsl:if test=". = ''"><br/></xsl:if>
				</xsl:if>
			</td>
		</xsl:for-each>
	</tr>
</xsl:template>
</xsl:stylesheet>
